<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class Bill extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_date'])->format($format));
    }

    public function getBillDueDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_due_date'])->format($format));
    }

    public function getBillElectricTotal()
    {
        return format_money($this->attributes['bill_electric_total']);
    }

    public function getBillWaterTotal()
    {
        return format_money($this->attributes['bill_water_total']);
    }

    public function getBillServiceTotal()
    {
        return format_money($this->attributes['bill_service_total']);
    }

    public function getBillOtherTotal()
    {
        return format_money($this->attributes['bill_other_total']);
    }

    public function getBillFineTotal()
    {
    	return format_money($this->attributes['bill_fine_total']);
    }

    public function overPayment()
    {	
    	return (int) $this->attributes['payment_last_month'] - $this->attributes['bill_last_month'];

    }

    public function totalBill()
    {
        return format_money($this->attributes['bill_amount']);
    }

    public function billRemaining() {

        return (int) $this->attributes['bill_amount'] + $this->attributes['bill_fine_total'] - ( $this->attributes['payment_amount'] + $this->overPayment() );
    }

    public function getPaymentLastMonth() {

    	return format_money($this->overPayment());
    }

    public function getPaymentAmount() {

        return format_money($this->attributes['payment_amount']);
    }

    public function getBillAmount() {

    	return format_money($this->billRemaining());

    }

    public function getStatus() {

        $status = ( $this->billRemaining() > 0 ) ? 'OUTSTANDING' : 'COMPLETED';

        return $status; 
    }


}