<?php 

function format_money($money = 0) {
	return 'Rp '.number_format($money, 0, '', '.');
}

function format_point($point = 0) {

    if( is_numeric( $point ) && floor( $point ) != $point )
        return number_format($point, 2, ',', '.');

    return number_format($point, 0, '', '.');
}

function format_date($date) {

    $monthName = array (1 =>   'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    );

    $date = explode('-', $date);

    $month = $monthName[ (int) $date[1] ];


    return $date[2].' '.$month.' '.$date[0]; 
}

function format_short_date($date) {

    $monthName = array (1 =>   'Jan',
        'Feb',
        'Mar',
        'Apr',
        'Mei',
        'Jun',
        'Jul',
        'Agst',
        'Sep',
        'Okt',
        'Nov',
        'Des'
    );

    $date = explode('-', $date);

    $month = $monthName[ (int) $date[1] ];


    return $date[2].' '.$month.' '.$date[0]; 
}


