<?php

namespace App\Models;

use CodeIgniter\Model;

class BillOtherM extends Model
{
    protected $table      = 'bill_others bo';
    protected $primaryKey = 'bill_other_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\BillOther';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {


        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('bo.bill_other_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getDetail($params = []) {

        $data = [
            'bill_electric_id'  => 1,
            'unit_name'         => 'W 33/21',
            'occupant_name'     => 'John Doe',
            'bill_code'         => 'BILL/W3321/0001',
            'bill_date'         =>  '2021-07-01 06:00:00', 
            'insurance'         => 0,
            'pbb'               => 0,
            'sinking_fund'      => 100000,
            'slf'               => 0,
            'hgb'               => 0,
            'parking_fee'       => 100000,
            'bill_other_amount'    => 200000,
            'bill_other_ppn'       => 20000,
            'bill_other_total'     => 220000,
            'status'               => 0
        ];

        $r = new \App\Entities\BillOther();
        $result = $r->fill($data);

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}