<?php

namespace App\Controllers;

class Bill extends BaseController
{	
	protected $billm;

	public function __construct()
	{
		$this->billm = new \App\Models\BillM();
	}

	public function index()
	{
		return;
	}

	public function owner_checking()
	{
		$data['page_title'] = 'BILLING OWNER CHECKING';
		$data['page_title_html'] = 'BILLING <small>OWNER CHECKING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking')
		];

		return view('Bill/owner_checking', $data);
	}

	public function owner_checking_table()
	{
		return view('Bill/owner_checking_table');
	}

	public function owner_checking_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billm->getList($params);

		foreach( $data as $d ) {

			$no++;

			$checkbox = '<input type="checkbox" name="bill_id[]" class="checkboxes" value="'.$d->bill_id.'"/>';

			$actions = '<div class="btn-group">
							<button class="btn blue dropdown-toggle" type="button" data-toggle="dropdown">
								Actions <i class="fa fa-angle-down"></i>
							</button>
							<ul class="dropdown-menu" role="menu">
								<li>
									<a href="'.base_url('bill/owner_checking_view/'.$d->bill_id).'">
										<i class="fa fa-search"></i> View 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_checking_edit/'.$d->bill_id).'">
										<i class="fa fa-edit"></i> Edit 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_checking_delete/'.$d->bill_id).'">
										<i class="fa fa-remove"></i> Delete 
									</a>
								</li>
								<li class="divider">
								</li>
							</ul>
						</div>';

			$bill_electric_total = $d->bill_electric_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billelectric/modal_detail/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_water_total = $d->bill_water_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billwater/modal_detail/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_service_total = $d->bill_service_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billservice/modal_detail/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$bill_other_total = $d->bill_other_total.' <a href="javascript:;" class="btn btn-xs blue open-modal" data-url="'.base_url('billother/modal_detail/'.$d->bill_id).'"><i class="fa fa-search"></i></a>';

			$records['data'][] = [
				$checkbox,
				$d->bill_code,
				$d->unit_va,
				$d->occupant_name,
				$d->unit_name,
				$d->bill_date,
				$d->bill_due_date,
				$bill_electric_total,
				$bill_water_total,
				$bill_service_total,
				$bill_other_total,
				$d->bill_total,
				$d->bill_fine_total,
				$d->payment_last_month,
				$d->payment_amount,
				$d->formatBillRemaining(),
				$d->status,
				$actions
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function owner_checking_add() {


		$data['page_title'] = 'ADD NEW BILLING';
		$data['page_title_html'] = 'ADD <small>NEW BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Add New Billing' => base_url('bill/owner_checking_add')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_add');

		return view('Bill/owner_checking_form', $data);

	}

	public function owner_checking_edit($id = 0) {
		
		$data['page_title'] = 'EDIT BILLING';
		$data['page_title_html'] = 'EDIT <small>BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Edit Billing' => base_url('bill/owner_checking_edit')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_edit');

		return view('Bill/owner_checking_form', $data);

	}

	public function owner_checking_view($id = 0) {
		return;
	}

	public function owner_checking_delete($id = 0) {

		return redirect()->to(base_url('bill/owner_checking'));
	}

	public function email()
	{
		$data['page_title'] = 'BILLING EMAIL INFORMATION';
		$data['page_title_html'] = 'BILLING <small>EMAIL INFORMATION</small>';
		$data['breadcrumb'] = [
			'Billing Email' => base_url('bill/email')
		];

		return view('Bill/email', $data);
	}

	public function email_table()
	{
		return view('Bill/email_table');
	}

	public function email_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billm->getList($params);

		foreach( $data as $d ) {

			$no++;

			$checkbox = '<input type="checkbox" name="bill_id[]" class="checkboxes" value="'.$d->bill_id.'"/>';

			$records['data'][] = [
				$checkbox,
				$d->bill_code,
				$d->occupant_name,
				$d->unit_name,
				$d->occupant_email,
				$d->bill_date,
				$d->bill_due_date,
				$d->formatBillRemaining(),
				$d->status
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function aging()
	{
		$data['page_title'] = 'BILLING AGING INFORMATION';
		$data['page_title_html'] = 'BILLING <small>AGING INFORMATION</small>';
		$data['breadcrumb'] = [
			'Billing Email' => base_url('bill/aging')
		];

		return view('Bill/aging', $data);
	}

	public function aging_table()
	{
		return view('Bill/aging_table');
	}

	public function aging_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billm->getAgingList($params);

		foreach( $data as $d ) {

			$no++;

			$records['data'][] = [
				$d->unit_name,
				$d->occupant_name,
				$d->outstanding_new,
				$d->outstanding_one_month,
				$d->outstanding_two_month,
				$d->outstanding_three_month,
				$d->outstanding_four_month,
				$d->outstanding_total,
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function owner()
	{
		$data['page_title'] = 'BILLING OWNER INFORMATION';
		$data['page_title_html'] = 'BILLING <small>OWNER INFORMATION</small>';
		$data['breadcrumb'] = [
			'Billing Owner' => base_url('bill/owner')
		];

		return view('Bill/owner', $data);
	}

	public function owner_table()
	{
		return view('Bill/owner_table');
	}

	public function owner_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billm->getList($params);

		foreach( $data as $d ) {

			$no++;

			$checkbox = '<input type="checkbox" name="bill_id[]" class="checkboxes" value="'.$d->bill_id.'"/>';

			$actions = '<div class="btn-group">
							<button class="btn blue dropdown-toggle" type="button" data-toggle="dropdown">
								Actions <i class="fa fa-angle-down"></i>
							</button>
							<ul class="dropdown-menu" role="menu">
								<li>
									<a href="'.base_url('bill/owner_view/'.$d->bill_id).'">
										<i class="fa fa-search"></i> View 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_edit/'.$d->bill_id).'">
										<i class="fa fa-edit"></i> Edit 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_invoice/'.$d->bill_id).'">
										<i class="fa fa-print"></i> Create Invoice 
									</a>
								</li>
								<li>
									<a href="'.base_url('bill/owner_full_invoice/'.$d->bill_id).'">
										<i class="fa fa-print"></i> Create Full Invcice 
									</a>
								</li>
							</ul>
						</div>';

			$records['data'][] = [
				$checkbox,
				$d->bill_code,
				$d->occupant_name,
				$d->unit_name,
				$d->bill_date,
				$d->bill_due_date,
				$d->bill_total,
				$d->bill_fine_total,
				$d->payment_last_month,
				$d->payment_amount,
				$d->formatBillRemaining(),
				$d->status,
				$actions
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function test_db() {

		$data = $this->billm->getList();

		foreach($data as $d) {
			print_r($d->toArray());
			echo '<br><br>';
		}

		return;
	}

}
