<?php

namespace App\Controllers;

class BillFine extends BaseController
{	
	protected $billFinem;

	public function __construct()
	{
		$this->billFinem = new \App\Models\BillFineM();
	}

	public function index()
	{
		return;
	}

	public function list()
	{
		$data['page_title'] = 'LATE CHARGE LIST';
		$data['page_title_html'] = 'LATE CHARGE  <small>LIST</small>';
		$data['breadcrumb'] = [
			'Late Charge List' => base_url('billfine/list')
		];

		return view('BillFine/list', $data);
	}

	public function list_table()
	{
		return view('BillFine/list_table');
	}

	public function list_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->billFinem->getList($params);

		foreach( $data as $d ) {

			$no++;

			$records['data'][] = [
				$d->bill_code,
				$d->unit_name,
				$d->occupant_name,
				$d->bill_due_date,
				$d->payment_date,
				$d->bill_total,
				$d->Days(),
				$d->bill_fine_total,
				$d->bill_fine_date,
				$d->payment_amount,
				$d->formatBillFineRemaining()
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function test_db() {

		$data = $this->billm->getList();

		foreach($data as $d) {
			print_r($d->toArray());
			echo '<br><br>';
		}

		return;
	}

}
