<?php

namespace App\Controllers;

class Collection extends BaseController
{	

	protected $unitm;

	public function __construct()
	{
		
	}

	public function index()
	{
		return;
	}

	public function receivable_card()
	{
		$data['page_title'] = 'RECEIVABLE CARD INFORMATION';
		$data['page_title_html'] = 'RECEIVABLE CARD <small>INFORMATION</small>';
		$data['breadcrumb'] = [
			'Receivable Card' => base_url('collection/receivable_card')
		];

		return view('Collection/receivable_card', $data);
	}

	public function receivable_card_table()
	{
		return view('Collection/receivable_card_table');
	}

	public function receivable_card_ajax()
	{
		
		$this->unitm = new \App\Models\UnitM();

		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->unitm->getCollectionList($params);

		foreach( $data as $d ) {

			$no++;

			$actions = '<div class="btn-group">
							<a class="btn blue" href="'.base_url('collection/view/'.$d->unit_id).'">
										<i class="fa fa-search"></i> View 
							</a>
							<a class="btn yellow" href="'.base_url('collection/sp_letter/'.$d->unit_id).'">
										<i class="fa fa-file-text-o"></i> SP Letter 
							</a>
							<a class="btn red" href="'.base_url('collection/sps_letter/'.$d->unit_id).'">
										<i class="fa fa-files-o"></i> SPS Letter 
							</a>
						</div>';

			$records['data'][] = [
				$d->unit_name,
				$d->owner_name,
				$actions
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	public function owner_checking_add() {


		$data['page_title'] = 'ADD NEW BILLING';
		$data['page_title_html'] = 'ADD <small>NEW BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Add New Billing' => base_url('bill/owner_checking_add')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_add');

		return view('Bill/owner_checking_form', $data);

	}

	public function owner_checking_edit($id = 0) {
		
		$data['page_title'] = 'EDIT BILLING';
		$data['page_title_html'] = 'EDIT <small>BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Edit Billing' => base_url('bill/owner_checking_edit')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_edit');

		return view('Bill/owner_checking_form', $data);

	}

	public function view($id = 0) {
		return redirect()->to(base_url('collection/receivable_card'));
	}

	public function sp_letter($id = 0) {

		return redirect()->to(base_url('collection/receivable_card'));
	}

	public function sps_letter($id = 0) {

		return redirect()->to(base_url('collection/receivable_card'));
	}

	public function test_db() {

		$data = $this->billm->getList();

		foreach($data as $d) {
			print_r($d->toArray());
			echo '<br><br>';
		}

		return;
	}

}
