<?php

namespace App\Controllers;

class Payment extends BaseController
{	
	protected $paymentm;

	public function __construct()
	{
		$this->paymentm = new \App\Models\Paymentm();
	}

	public function index()
	{
		return;
	}

	public function list()
	{
		$data['page_title'] = 'DAILY PAYMENT LIST';
		$data['page_title_html'] = 'DAILY PAYMENT <small>LIST</small>';
		$data['breadcrumb'] = [
			'Payment List' => base_url('payment/list')
		];

		return view('Payment/list', $data);
	}

	public function list_table()
	{
		return view('Payment/list_table');
	}

	public function list_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->paymentm->getList($params);

		foreach( $data as $d ) {

			$no++;

			$checkbox = '<input type="checkbox" name="payment_id[]" class="checkboxes" value="'.$d->payment_id.'"/>';

			$actions = '<div class="btn-group">
							<button class="btn blue dropdown-toggle" type="button" data-toggle="dropdown">
								Actions <i class="fa fa-angle-down"></i>
							</button>
							<ul class="dropdown-menu" role="menu">
								<li>
									<a href="'.base_url('payment/receipt/'.$d->payment_id).'">
										<i class="fa fa-print"></i> Print Receipt 
									</a>
								</li>
								<li>
									<a href="'.base_url('payment/edit/'.$d->payment_id).'">
										<i class="fa fa-edit"></i> Edit 
									</a>
								</li>
								<li>
									<a href="'.base_url('payment/delete/'.$d->payment_id).'">
										<i class="fa fa-remove"></i> Delete 
									</a>
								</li>
								<li class="divider">
								</li>
							</ul>
						</div>';

			$records['data'][] = [
				$checkbox,
				$d->payment_code,
				$d->bill_code,
				$d->unit_name,
				$d->bill_total,
				$d->payment_date,
				$d->payment_ref_date,
				$d->payment_amount,
				$d->mr_x,
				$d->credit_note_status,
				$d->payment_method_name,
				$actions
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}

	/*
	public function owner_checking_add() {


		$data['page_title'] = 'ADD NEW BILLING';
		$data['page_title_html'] = 'ADD <small>NEW BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Add New Billing' => base_url('bill/owner_checking_add')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_add');

		return view('Bill/owner_checking_form', $data);

	}

	public function owner_checking_edit($id = 0) {
		
		$data['page_title'] = 'EDIT BILLING';
		$data['page_title_html'] = 'EDIT <small>BILLING</small>';
		$data['breadcrumb'] = [
			'Billing Owner Checking' => base_url('bill/owner_checking'),
			'Edit Billing' => base_url('bill/owner_checking_edit')
		];

		$data['occupants'] = [];
		$data['d'] = new \App\Entities\Bill();
		$data['action'] = base_url('bill/owner_checking_edit');

		return view('Bill/owner_checking_form', $data);

	}
	*/

	public function owner_checking_view($id = 0) {
		return;
	}

	public function receipt($id = 0) {

		return redirect()->to(base_url('bill/owner_checking'));
	}

	public function edit($id = 0) {

		return redirect()->to(base_url('bill/owner_checking'));
	}

	public function delete($id = 0) {

		return redirect()->to(base_url('bill/owner_checking'));
	}

	public function over_payment()
	{
		$data['page_title'] = 'OVER PAYMENT LIST';
		$data['page_title_html'] = 'OVER PAYMENT <small>LIST</small>';
		$data['breadcrumb'] = [
			'Over Payment List' => base_url('payment/over_payment')
		];

		return view('Payment/over_payment', $data);
	}

	public function over_payment_table()
	{
		return view('Payment/over_payment_table');
	}

	public function over_payment_ajax()
	{
		
		$start = 0;
		$length = 0;
		$order = '';
		$sort = [];
		$params = [];
		$records = [];
		$sEcho = intval($this->request->getPost('draw'));

		if( $this->request->getPost('start') ) {
			$start = intval($this->request->getPost('start'));
		}

		if ( intval($this->request->getPost('length')) > 0 ) {
			$length = intval($this->request->getPost('length'));
		}

		//$TotalRecords = $this->model->count()->total;
		$TotalRecords = 50;

		$filtered = false;

		$TotalRecordsFiltered = $TotalRecords;

		if( $filtered ) {
			//$TotalRecordsFiltered = $this->model->count($params)->total;
			$TotalRecordsFiltered = 0;
		}

		$records['data'] = [];
		$no = $start;

		$data = $this->paymentm->getOverPaymentList($params);

		foreach( $data as $d ) {

			$no++;

			$records['data'][] = [
				$d->bill_code,
				$d->unit_name,
				$d->occupant_name,
				$d->over_payment_month,
				$d->over_payment_year,
				$d->over_payment_amount
			];

		}


		$records["draw"] = $sEcho;
		$records["recordsTotal"] = $TotalRecords;
		$records["recordsFiltered"] = $TotalRecordsFiltered;
		
		return json_encode($records);
	}


	public function test_db() {

		$data = $this->billm->getList();

		foreach($data as $d) {
			print_r($d->toArray());
			echo '<br><br>';
		}

		return;
	}

}
