<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class BillOther extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getBillDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['bill_date'])->format($format));
    }

    public function getInsurance()
    {
        return format_money($this->attributes['insurance']);
    }

    public function getPbb()
    {
        return format_money($this->attributes['pbb']);
    }

    public function getSinkingFund()
    {
        return format_money($this->attributes['sinking_fund']);
    }

    public function getSlf()
    {
        return format_money($this->attributes['slf']);
    }

    public function getHgb()
    {
        return format_money($this->attributes['hgb']);
    }

    public function getParkingFee()
    {
        return format_money($this->attributes['parking_fee']);
    }

    public function getBillOtherAmount()
    {
        return format_money($this->attributes['bill_other_amount']);
    }

    public function getBillOtherPpn()
    {
        return format_money($this->attributes['bill_other_ppn']);
    }

    public function getBillOtherTotal()
    {
        return format_money($this->attributes['bill_other_total']);
    }

    public function getStatus() {

        $status = ( $this->attributes['status'] == 0 ) ? '<span class="label label-danger circle">OUTSTANDING</span>' : '<span class="label label-success circle">COMPLETED</span>';

        return $status; 
    }


}