<?php

namespace App\Entities;

use CodeIgniter\Entity\Entity;
use CodeIgniter\I18n\Time;

class Payment extends Entity
{
    //protected $dates = ['bill_date', 'bill_due_date'];

    public function __construct()
	{
		helper('general');
	}

    public function getPaymentDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['payment_date'])->format($format));
    }

    public function getPaymentRefDate(string $format = 'Y-m-d') {

        return format_date($this->mutateDate($this->attributes['payment_ref_date'])->format($format));
    }

    public function getPaymentAmount()
    {
        return format_money($this->attributes['payment_amount']);
    }

    public function getBillTotal() {

        return format_money($this->attributes['bill_total']);

    }

    public function getMrX() {

        $string = ( $this->attributes['mr_x'] == 0 ) ? 'NO' : 'YES';

        return $string; 
    }

    public function getCreditNoteStatus() {

        $string = ( $this->attributes['credit_note_status'] == 0 ) ? 'NO' : 'YES';

        return $string; 
    }

    public function getOverPaymentMonth() {

        return format_month($this->attributes['over_payment_month']);
    }

    public function getOverPaymentAmount()
    {
        return format_money($this->attributes['over_payment_amount']);
    }


}