<?php

namespace App\Models;

use CodeIgniter\Model;

class BillElectricM extends Model
{
    protected $table      = 'bill_electrics be';
    protected $primaryKey = 'bill_electric_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\BillElectric';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {


        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('be.bill_electric_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getDetail($params = []) {

        $data = [
            'bill_electric_id'  => 1,
            'unit_name'         => 'W 33/21',
            'occupant_name'     => 'John Doe',
            'bill_code'         => 'BILL/W3321/0001',
            'bill_date'         =>  '2021-07-01 06:00:00', 
            'electric_usage_start'  => 2679.10,
            'electric_usage_end'    => 2681.70,
            'electric_usage_amount' => 2.60,
            'electric_meter_rate'   => 1444,
            'electric_meter_power'  => 4.40,
            'electric_meter_service'    => 50000, 
            'bill_electric_amount'      => 3754,
            'bill_electric_service'     => 220000,
            'bill_electric_pju'         => 15662,
            'bill_electric_admin'       => 11971,
            'bill_electric_ppn'         => 25139,
            'bill_electric_total'       => 276526,
            'status'                    => 0
        ];

        $r = new \App\Entities\BillElectric();
        $result = $r->fill($data);

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}