<?php

namespace App\Models;

use CodeIgniter\Model;

class BillFineM extends Model
{
    protected $table      = 'bill_fines bf';
    protected $primaryKey = 'bill_fine_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\BillFine';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {

        $data = [
            'bill_fine_id'      => 0,
            'payment_id'        => 0,
            'bill_id'           => 0,
            'occupant_id'       => 0,
            'occupant_name'     => 'John Doe',
            'unit_name'     => 'W 33/21',
            'bill_code'     => 'BILL/W3321/0001',
            'bill_due_date' =>  '2021-07-15 00:00:00',
            'payment_date' =>  NULL,
            'payment_amount'   => 0,
            'bill_fine_total'   => 100000,
            'bill_fine_date'    => NULL,
            'bill_total'    => 2582017,
        ];

        $result = [];

        $length = !empty($params['length']) ? $params['length'] : 10;
        $start = !empty($params['start']) ? $params['start'] : 0;

        for ($x = $start; $x < $length; $x++) {
            $data['bill_fine_id'] = $x+1;
            $data['payment_id'] = $x+1;
            $data['bill_id'] = $x+1;
            $data['occupant_id'] = $x+1;
            $r = new \App\Entities\BillFine();
            $result[] = $r->fill($data);
        }

        return $result;


        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('bf.bill_fine_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getDetail($params = []) {

        $data = [
            'bill_electric_id'  => 1,
            'unit_name'         => 'W 33/21',
            'occupant_name'     => 'John Doe',
            'bill_code'         => 'BILL/W3321/0001',
            'bill_date'         =>  '2021-07-01 06:00:00', 
            'water_usage_start'  => 83.37,
            'water_usage_end'    => 106.64,
            'water_usage_amount' => 23.27,
            'water_meter_rate'   => 9000,
            'bill_water_amount'    => 209430,
            'bill_water_fixed'     => 25000,
            'bill_water_admin'     => 11971,
            'bill_water_ppn'       => 24615,
            'bill_water_total'     => 270766,
            'status'               => 0
        ];

        $r = new \App\Entities\BillWater();
        $result = $r->fill($data);

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}