<?php

namespace App\Models;

use CodeIgniter\Model;

class BillServiceM extends Model
{
    protected $table      = 'bill_services bs';
    protected $primaryKey = 'bill_service_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\BillService';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {


        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('bs.bill_service_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getDetail($params = []) {

        $data = [
            'bill_electric_id'  => 1,
            'unit_name'         => 'W 33/21',
            'unit_size'         => 65.99,
            'occupant_name'     => 'John Doe',
            'bill_code'         => 'BILL/W3321/0001',
            'bill_date'         =>  '2021-07-01 06:00:00', 
            'service_charge_rate'  => 25000,
            'bill_service_amount'    => 1649750,
            'bill_service_ppn'       => 164975,
            'bill_service_total'     => 1814725,
            'status'               => 0
        ];

        $r = new \App\Entities\BillService();
        $result = $r->fill($data);

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}