<?php

namespace App\Models;

use CodeIgniter\Model;

class BillWaterM extends Model
{
    protected $table      = 'bill_waters bw';
    protected $primaryKey = 'bill_water_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\BillWater';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {


        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('bw.bill_water_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getDetail($params = []) {

        $data = [
            'bill_electric_id'  => 1,
            'unit_name'         => 'W 33/21',
            'occupant_name'     => 'John Doe',
            'bill_code'         => 'BILL/W3321/0001',
            'bill_date'         =>  '2021-07-01 06:00:00', 
            'water_usage_start'  => 83.37,
            'water_usage_end'    => 106.64,
            'water_usage_amount' => 23.27,
            'water_meter_rate'   => 9000,
            'bill_water_amount'    => 209430,
            'bill_water_fixed'     => 25000,
            'bill_water_admin'     => 11971,
            'bill_water_ppn'       => 24615,
            'bill_water_total'     => 270766,
            'status'               => 0
        ];

        $r = new \App\Entities\BillWater();
        $result = $r->fill($data);

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}