<?php

namespace App\Models;

use CodeIgniter\Model;

class Paymentm extends Model
{
    protected $table      = 'payments p';
    protected $primaryKey = 'payment_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\Payment';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getList($params = []) {

        $data = [
            'payment_id'        => 0,
            'bill_id'           => 0,
            'payment_method_id' => 1,
            'payment_code'      => 'PAY/W6A01/0025',
            'payment_date'      =>  '2021-07-14 06:00:00', 
            'payment_ref_date'  =>  '2021-07-14 06:00:00', 
            'payment_amount'    => 2582017,
            'mr_x'                  => 0,
            'credit_note_status'    => 0,
            'unit_va'               => '00130080012345',
            'unit_name'             => 'W 33/21',
            'bill_code'             => 'BILL/W3321/0001',
            'bill_total'            => 2582017,
            'payment_method_name'   => 'VIRTUAL ACCOUNT'
        ];

        $result = [];

        $length = !empty($params['length']) ? $params['length'] : 10;
        $start = !empty($params['start']) ? $params['start'] : 0;

        for ($x = $start; $x < $length; $x++) {
            $data['payment_id'] = $x+1;
            $data['bill_id'] = $x+1;
            
            $r = new \App\Entities\Payment();
            $result[] = $r->fill($data);
        }

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('p.payment_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    public function getOverPaymentList($params = []) {

        
        $data = [
            'bill_id'               => 0,
            'over_payment_month'    =>  '07', 
            'over_payment_year'     =>  '2021', 
            'over_payment_amount'   => 100000,
            'bill_code'             => 'BILL/W3321/0001',
            'unit_name'             => 'W 33/21',
            'occupant_name'         => 'John Doe',
        ];

        $result = [];

        $length = !empty($params['length']) ? $params['length'] : 10;
        $start = !empty($params['start']) ? $params['start'] : 0;

        for ($x = $start; $x < $length; $x++) {
            $data['bill_id'] = $x+1;
            $r = new \App\Entities\Payment();
            $result[] = $r->fill($data);
        }

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('b.bill_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }
}