<?php

namespace App\Models;

use CodeIgniter\Model;

class UnitM extends Model
{
    protected $table      = 'units u';
    protected $primaryKey = 'unit_id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'App\Entities\Bill';
    protected $useSoftDeletes = false;

    //protected $allowedFields = ['name', 'email'];

    protected $useTimestamps = true;
    protected $createdField  = 'created';
    protected $updatedField  = 'updated';
    //protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function getCollectionList($params = []) {

        $data = [
            'unit_id'           => 0,
            'ownership_id'      => 0,
            'owner_name'        => 'John Doe',
            'unit_name'     => 'W 33/21'
        ];

        $result = [];

        $length = !empty($params['length']) ? $params['length'] : 10;
        $start = !empty($params['start']) ? $params['start'] : 0;

        for ($x = $start; $x < $length; $x++) {
            $data['unit_id'] = $x+1;
            $data['ownership_id'] = $x+1;
            $r = new \App\Entities\Bill();
            $result[] = $r->fill($data);
        }

        return $result;

        if(!empty($params['where']))
            $this->where($params['where']);

        if( !empty($params['sort']) ) {
            $this->orderBy($params['sort']['column'], $params['sort']['dir']);
        } else {
           $this->orderBy('u.unit_id');
        }

        if(!empty($params['length']))
            $this->limit($params['length'],$params['start']);

        $query = $this->get();

        if($query->getNumRows() > 0) {

            return $query->getResult();

        }

        return false;

    }

    
}