-- phpMyAdmin SQL Dump
-- version 5.0.4
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Aug 14, 2021 at 05:53 AM
-- Server version: 10.5.8-MariaDB
-- PHP Version: 7.4.16

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `skandinavia`
--

-- --------------------------------------------------------

--
-- Table structure for table `bills`
--

CREATE TABLE `bills` (
  `bill_id` int(11) NOT NULL,
  `occupant_id` int(11) DEFAULT NULL,
  `bill_code` varchar(50) DEFAULT NULL,
  `bill_description` varchar(255) DEFAULT NULL,
  `bill_date` datetime DEFAULT NULL,
  `bill_due_date` datetime DEFAULT NULL,
  `bill_grace_date` datetime DEFAULT NULL,
  `bill_amount` double DEFAULT NULL,
  `stamp_fee` double NOT NULL DEFAULT 0,
  `bill_total` double NOT NULL DEFAULT 0,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bill_electrics`
--

CREATE TABLE `bill_electrics` (
  `bill_electric_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `electric_usage_id` int(11) DEFAULT NULL,
  `bill_electric_amount` double DEFAULT NULL,
  `bill_electric_service` double DEFAULT NULL,
  `bill_electric_pju` double DEFAULT NULL,
  `bill_electric_admin` double DEFAULT NULL,
  `bill_electric_ppn` double DEFAULT NULL,
  `bill_electric_total` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bill_fines`
--

CREATE TABLE `bill_fines` (
  `bill_fine_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `payment_id` int(11) DEFAULT NULL,
  `bill_fine_description` double DEFAULT NULL,
  `bill_fine_date` datetime DEFAULT NULL,
  `bill_fine_amount` double DEFAULT NULL,
  `bill_fine_ppn` double NOT NULL DEFAULT 0,
  `bill_fine_total` double NOT NULL DEFAULT 0,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bill_others`
--

CREATE TABLE `bill_others` (
  `bill_other_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `other_charge_id` int(11) DEFAULT NULL,
  `bill_other_amount` double DEFAULT NULL,
  `bill_other_ppn` double DEFAULT NULL,
  `bill_other_total` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bill_services`
--

CREATE TABLE `bill_services` (
  `bill_service_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `service_charge_id` int(11) DEFAULT NULL,
  `bill_service_amount` double DEFAULT NULL,
  `bill_service_ppn` double DEFAULT NULL,
  `bill_service_total` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bill_waters`
--

CREATE TABLE `bill_waters` (
  `bill_water_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `water_usage_id` int(11) DEFAULT NULL,
  `bill_water_amount` double DEFAULT NULL,
  `bill_water_fixed` double NOT NULL DEFAULT 0,
  `bill_water_admin` double DEFAULT NULL,
  `bill_water_ppn` double DEFAULT NULL,
  `bill_water_total` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `data_electric_usages`
--

CREATE TABLE `data_electric_usages` (
  `electric_usage_id` int(11) NOT NULL,
  `electric_meter_id` int(11) DEFAULT NULL,
  `electric_usage_start` double DEFAULT NULL,
  `electric_usage_end` double DEFAULT NULL,
  `electric_usage_amount` double DEFAULT NULL,
  `electric_usage_period` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `data_water_usages`
--

CREATE TABLE `data_water_usages` (
  `water_usage_id` int(11) NOT NULL,
  `water_meter_id` int(11) DEFAULT NULL,
  `water_usage_start` double DEFAULT NULL,
  `water_usage_end` double DEFAULT NULL,
  `water_usage_amount` double DEFAULT NULL,
  `water_usage_period` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `master_settings`
--

CREATE TABLE `master_settings` (
  `setting_id` int(11) NOT NULL,
  `setting_name` text DEFAULT NULL,
  `setting_value` text DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `occupancies`
--

CREATE TABLE `occupancies` (
  `occupant_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `occupant_start_date` datetime DEFAULT NULL,
  `occupant_end_date` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `ownerships`
--

CREATE TABLE `ownerships` (
  `ownership_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `ownership_start_date` datetime DEFAULT NULL,
  `ownership_end_date` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `payment_id` int(11) NOT NULL,
  `bill_id` int(11) DEFAULT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `payment_code` varchar(255) DEFAULT NULL,
  `payment_description` varchar(255) DEFAULT NULL,
  `payment_amount` double DEFAULT NULL,
  `payment_over` double DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_ref_date` datetime DEFAULT NULL,
  `credit_note` varchar(255) DEFAULT NULL,
  `credit_note_status` tinyint(1) DEFAULT NULL,
  `mr_x` tinyint(1) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `payment_methods`
--

CREATE TABLE `payment_methods` (
  `payment_method_id` int(11) NOT NULL,
  `payment_method_name` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

CREATE TABLE `units` (
  `unit_id` int(11) NOT NULL,
  `unit_type_id` int(11) DEFAULT NULL,
  `unit_code` varchar(50) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `unit_size` double DEFAULT NULL,
  `unit_va` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit_electric_meters`
--

CREATE TABLE `unit_electric_meters` (
  `electric_meter_id` int(11) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `electric_meter_description` text DEFAULT NULL,
  `electric_meter_rate` double DEFAULT NULL,
  `electric_meter_power` double DEFAULT NULL,
  `electric_meter_service` double DEFAULT NULL,
  `electric_meter_pju` double DEFAULT NULL,
  `electric_meter_admin` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit_other_charges`
--

CREATE TABLE `unit_other_charges` (
  `other_charge_id` int(11) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `other_charge_description` text DEFAULT NULL,
  `insurance` double DEFAULT NULL,
  `pbb` double DEFAULT NULL,
  `sinking_fund` double DEFAULT NULL,
  `slf` double DEFAULT NULL,
  `hgb` double DEFAULT NULL,
  `parking_fee` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit_service_charges`
--

CREATE TABLE `unit_service_charges` (
  `service_charge_id` int(11) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `service_charge_description` text DEFAULT NULL,
  `service_charge_rate` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit_types`
--

CREATE TABLE `unit_types` (
  `unit_type_id` int(11) NOT NULL,
  `unit_type_name` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `unit_water_meters`
--

CREATE TABLE `unit_water_meters` (
  `water_meter_id` int(11) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `water_meter_description` text DEFAULT NULL,
  `water_meter_rate` double DEFAULT NULL,
  `water_meter_fixed` double DEFAULT NULL,
  `water_meter_admin` double DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL,
  `user_type_id` int(11) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `user_phone` varchar(20) DEFAULT NULL,
  `user_email` varchar(100) DEFAULT NULL,
  `user_address` varchar(255) DEFAULT NULL,
  `user_city` varchar(50) DEFAULT NULL,
  `user_sub_district` varchar(50) DEFAULT NULL,
  `user_village` varchar(50) DEFAULT NULL,
  `user_password` text DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `user_accesses`
--

CREATE TABLE `user_accesses` (
  `user_access_id` int(11) NOT NULL,
  `user_access_code` varchar(50) DEFAULT NULL,
  `user_access_name` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `user_menus`
--

CREATE TABLE `user_menus` (
  `user_menu_id` int(11) NOT NULL,
  `user_menu_code` varchar(50) NOT NULL,
  `user_menu_name` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `user_types`
--

CREATE TABLE `user_types` (
  `user_type_id` int(11) NOT NULL,
  `user_type_name` varchar(50) DEFAULT NULL,
  `user_access` text DEFAULT NULL,
  `user_menu` text DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `created` datetime DEFAULT current_timestamp(),
  `updated` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updatedby` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `bills`
--
ALTER TABLE `bills`
  ADD PRIMARY KEY (`bill_id`),
  ADD KEY `occupant_id` (`occupant_id`);

--
-- Indexes for table `bill_electrics`
--
ALTER TABLE `bill_electrics`
  ADD PRIMARY KEY (`bill_electric_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `electric_usage_id` (`electric_usage_id`);

--
-- Indexes for table `bill_fines`
--
ALTER TABLE `bill_fines`
  ADD PRIMARY KEY (`bill_fine_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `payment_id` (`payment_id`);

--
-- Indexes for table `bill_others`
--
ALTER TABLE `bill_others`
  ADD PRIMARY KEY (`bill_other_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `other_charge_id` (`other_charge_id`);

--
-- Indexes for table `bill_services`
--
ALTER TABLE `bill_services`
  ADD PRIMARY KEY (`bill_service_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `service_charge_id` (`service_charge_id`);

--
-- Indexes for table `bill_waters`
--
ALTER TABLE `bill_waters`
  ADD PRIMARY KEY (`bill_water_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `water_usage_id` (`water_usage_id`);

--
-- Indexes for table `data_electric_usages`
--
ALTER TABLE `data_electric_usages`
  ADD PRIMARY KEY (`electric_usage_id`),
  ADD KEY `electric_meter_id` (`electric_meter_id`);

--
-- Indexes for table `data_water_usages`
--
ALTER TABLE `data_water_usages`
  ADD PRIMARY KEY (`water_usage_id`),
  ADD KEY `water_meter_id` (`water_meter_id`);

--
-- Indexes for table `master_settings`
--
ALTER TABLE `master_settings`
  ADD PRIMARY KEY (`setting_id`);

--
-- Indexes for table `occupancies`
--
ALTER TABLE `occupancies`
  ADD PRIMARY KEY (`occupant_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `ownerships`
--
ALTER TABLE `ownerships`
  ADD PRIMARY KEY (`ownership_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`payment_id`),
  ADD KEY `bill_id` (`bill_id`),
  ADD KEY `payment_method_id` (`payment_method_id`);

--
-- Indexes for table `payment_methods`
--
ALTER TABLE `payment_methods`
  ADD PRIMARY KEY (`payment_method_id`);

--
-- Indexes for table `units`
--
ALTER TABLE `units`
  ADD PRIMARY KEY (`unit_id`),
  ADD KEY `unit_type_id` (`unit_type_id`);

--
-- Indexes for table `unit_electric_meters`
--
ALTER TABLE `unit_electric_meters`
  ADD PRIMARY KEY (`electric_meter_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `unit_other_charges`
--
ALTER TABLE `unit_other_charges`
  ADD PRIMARY KEY (`other_charge_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `unit_service_charges`
--
ALTER TABLE `unit_service_charges`
  ADD PRIMARY KEY (`service_charge_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `unit_types`
--
ALTER TABLE `unit_types`
  ADD PRIMARY KEY (`unit_type_id`);

--
-- Indexes for table `unit_water_meters`
--
ALTER TABLE `unit_water_meters`
  ADD PRIMARY KEY (`water_meter_id`),
  ADD KEY `unit_id` (`unit_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`user_id`),
  ADD KEY `user_type_id` (`user_type_id`);

--
-- Indexes for table `user_accesses`
--
ALTER TABLE `user_accesses`
  ADD PRIMARY KEY (`user_access_id`);

--
-- Indexes for table `user_menus`
--
ALTER TABLE `user_menus`
  ADD PRIMARY KEY (`user_menu_id`);

--
-- Indexes for table `user_types`
--
ALTER TABLE `user_types`
  ADD PRIMARY KEY (`user_type_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `bills`
--
ALTER TABLE `bills`
  MODIFY `bill_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bill_electrics`
--
ALTER TABLE `bill_electrics`
  MODIFY `bill_electric_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bill_fines`
--
ALTER TABLE `bill_fines`
  MODIFY `bill_fine_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bill_others`
--
ALTER TABLE `bill_others`
  MODIFY `bill_other_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bill_services`
--
ALTER TABLE `bill_services`
  MODIFY `bill_service_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `bill_waters`
--
ALTER TABLE `bill_waters`
  MODIFY `bill_water_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `data_electric_usages`
--
ALTER TABLE `data_electric_usages`
  MODIFY `electric_usage_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `data_water_usages`
--
ALTER TABLE `data_water_usages`
  MODIFY `water_usage_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `master_settings`
--
ALTER TABLE `master_settings`
  MODIFY `setting_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `occupancies`
--
ALTER TABLE `occupancies`
  MODIFY `occupant_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ownerships`
--
ALTER TABLE `ownerships`
  MODIFY `ownership_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `payment_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment_methods`
--
ALTER TABLE `payment_methods`
  MODIFY `payment_method_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `units`
--
ALTER TABLE `units`
  MODIFY `unit_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit_electric_meters`
--
ALTER TABLE `unit_electric_meters`
  MODIFY `electric_meter_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit_other_charges`
--
ALTER TABLE `unit_other_charges`
  MODIFY `other_charge_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit_service_charges`
--
ALTER TABLE `unit_service_charges`
  MODIFY `service_charge_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit_types`
--
ALTER TABLE `unit_types`
  MODIFY `unit_type_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `unit_water_meters`
--
ALTER TABLE `unit_water_meters`
  MODIFY `water_meter_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `user_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_accesses`
--
ALTER TABLE `user_accesses`
  MODIFY `user_access_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_menus`
--
ALTER TABLE `user_menus`
  MODIFY `user_menu_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_types`
--
ALTER TABLE `user_types`
  MODIFY `user_type_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `bills`
--
ALTER TABLE `bills`
  ADD CONSTRAINT `bills_ibfk_1` FOREIGN KEY (`occupant_id`) REFERENCES `occupancies` (`occupant_id`);

--
-- Constraints for table `bill_electrics`
--
ALTER TABLE `bill_electrics`
  ADD CONSTRAINT `bill_electrics_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `bill_electrics_ibfk_2` FOREIGN KEY (`electric_usage_id`) REFERENCES `data_electric_usages` (`electric_usage_id`);

--
-- Constraints for table `bill_fines`
--
ALTER TABLE `bill_fines`
  ADD CONSTRAINT `bill_fines_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `bill_fines_ibfk_2` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`payment_id`);

--
-- Constraints for table `bill_others`
--
ALTER TABLE `bill_others`
  ADD CONSTRAINT `bill_others_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `bill_others_ibfk_2` FOREIGN KEY (`other_charge_id`) REFERENCES `unit_other_charges` (`other_charge_id`);

--
-- Constraints for table `bill_services`
--
ALTER TABLE `bill_services`
  ADD CONSTRAINT `bill_services_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `bill_services_ibfk_2` FOREIGN KEY (`service_charge_id`) REFERENCES `unit_service_charges` (`service_charge_id`);

--
-- Constraints for table `bill_waters`
--
ALTER TABLE `bill_waters`
  ADD CONSTRAINT `bill_waters_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `bill_waters_ibfk_2` FOREIGN KEY (`water_usage_id`) REFERENCES `data_water_usages` (`water_usage_id`);

--
-- Constraints for table `data_electric_usages`
--
ALTER TABLE `data_electric_usages`
  ADD CONSTRAINT `data_electric_usages_ibfk_1` FOREIGN KEY (`electric_meter_id`) REFERENCES `unit_electric_meters` (`electric_meter_id`);

--
-- Constraints for table `data_water_usages`
--
ALTER TABLE `data_water_usages`
  ADD CONSTRAINT `data_water_usages_ibfk_1` FOREIGN KEY (`water_meter_id`) REFERENCES `unit_water_meters` (`water_meter_id`);

--
-- Constraints for table `occupancies`
--
ALTER TABLE `occupancies`
  ADD CONSTRAINT `occupancies_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `occupancies_ibfk_2` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `ownerships`
--
ALTER TABLE `ownerships`
  ADD CONSTRAINT `ownerships_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `ownerships_ibfk_2` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bills` (`bill_id`),
  ADD CONSTRAINT `payments_ibfk_2` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`payment_method_id`);

--
-- Constraints for table `units`
--
ALTER TABLE `units`
  ADD CONSTRAINT `units_ibfk_1` FOREIGN KEY (`unit_type_id`) REFERENCES `unit_types` (`unit_type_id`);

--
-- Constraints for table `unit_electric_meters`
--
ALTER TABLE `unit_electric_meters`
  ADD CONSTRAINT `unit_electric_meters_ibfk_1` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `unit_other_charges`
--
ALTER TABLE `unit_other_charges`
  ADD CONSTRAINT `unit_other_charges_ibfk_1` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `unit_service_charges`
--
ALTER TABLE `unit_service_charges`
  ADD CONSTRAINT `unit_service_charges_ibfk_1` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `unit_water_meters`
--
ALTER TABLE `unit_water_meters`
  ADD CONSTRAINT `unit_water_meters_ibfk_1` FOREIGN KEY (`unit_id`) REFERENCES `units` (`unit_id`);

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`user_type_id`) REFERENCES `user_types` (`user_type_id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
