var CustomModal = function () {

    return {
        //main function to initiate the module
        init: function () {
            
            // general settings
            $.fn.modal.defaults.spinner = $.fn.modalmanager.defaults.spinner = 
                '<div class="loading-spinner" style="width: 200px; margin-left: -100px;">' +
                    '<div class="progress progress-striped active">' +
                        '<div class="progress-bar" style="width: 100%;"></div>' +
                    '</div>' +
                '</div>';

            $.fn.modalmanager.defaults.resize = true;

            //ajax demo:
            var $modal = $('#ajax-modal');

            $('body').on('click','.open-modal', function(){
                // create the backdrop and wait for next modal to be triggered
                $('body').modalmanager('loading');

                var url = $(this).data('url')

                $modal = $('#ajax-modal')

                //console.log(base_url+'events/form/'+type);
                setTimeout(function(){

                    $modal.load(url, '', function(){
                        $modal.modal();
                    });
                    
                }, 1000);
            });

            $modal.on('click', '.save', function(){

                var $modal = $(this).parents('.modal'),
                    form = $(this).parents('.modal').find('form'),
                    url = form.attr('action'),
                    postData = form.serialize(),
                    reload = $(this).attr('data-reload') ? $(this).attr('data-reload') : ''

                bootbox.confirm({
                    title: 'Confirmation',
                    message: 'Save this change ?',
                    closeButton: false,
                    size: 'small',
                    callback: function (result) {

                        if( result ) {

                            Metronic.blockUI()
                            $('body').modalmanager('loading');

                            MyValidation.resetValidation(form)

                            var posting = $.post( url, postData )

                            posting.done( function(response) {

                                Metronic.unblockUI()
                                $('body').modalmanager('loading');

                                response = $.parseJSON(response)

                                //console.log(response)

                                var type = ( response.status ) ? 'success' : 'error'

                                if( !response.status ) {

                                    MyValidation.setError(response.data)
                                }

                                if( response.status ) {

                                    $modal.modal('hide')

                                    if( reload !== '' )
                                        $(reload).click()

                                }

                                Metronic.notif({
                                    type: type,
                                    message: response.message
                                })

                            })

                        }

                    }
                })


            });

            $('body').on('click', '.modal-choose', function(){

                //console.log('tes')

                var params = $(this).attr('data-params') ? JSON.parse($(this).attr('data-params')) : []

                //console.log($modal.attr('id'))
                //console.log(params);

                Metronic.blockUI()
                $modal.modal('loading')

                params.map((item) => {
                    if( $(item.field).length > 0 )
                        $(item.field).val(item.value)
                })

                Metronic.unblockUI()
                $modal.modal('hide')


            });


            /*

            $('#ajax-demo').on('click', function(){
              // create the backdrop and wait for next modal to be triggered
              $('body').modalmanager('loading');

              setTimeout(function(){
                  $modal.load('ui_extended_modals_ajax_sample.html', '', function(){
                  $modal.modal();
                });
              }, 1000);
            });

            $modal.on('click', '.update', function(){
              $modal.modal('loading');
              setTimeout(function(){
                $modal
                  .modal('loading')
                  .find('.modal-body')
                    .prepend('<div class="alert alert-info fade in">' +
                      'Updated!<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                    '</div>');
              }, 1000);
            });
            */
        }

    };

}();