var TableAjax = function () {


    var handleRecords = function (table) {

        var grid = new Datatable(),
            url = $(table).data('url'),
            save = true,
            disable_sorting = [],
            column_sorting = 0,
            orderable = true,
            dir_sorting = 'asc'

        if( $(table).attr('data-save') ) 
            save = $(table).data('save')

        if( $(table).attr('data-disable-sorting') )
            disable_sorting = $(table).data('disable-sorting')

        if( $(table).attr('data-column-sorting') )
            column_sorting = $(table).data('column-sorting')

        if( $(table).attr('data-dir-sorting') )
            dir_sorting = $(table).data('dir-sorting')

        if( disable_sorting.indexOf(0) >= 0 )
            orderable = false

        grid.init({
            src: $(table),
            onSuccess: function (grid) {
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function(grid) {
                // execute some code on ajax data load
            },
            loadingMessage: 'Loading...',
            dataTable: { // here you can define a typical datatable settings from http://datatables.net/usage/options 

                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",
                
                "bStateSave": save, // save datatable state(pagination, sort, etc) in cookie.

                "columnDefs": [{ // define columns sorting options(by default all columns are sortable extept the first checkbox column)
                    'orderable': orderable,
                    'targets': disable_sorting
                }],

                "lengthMenu": [
                    [10, 20, 50, 100, 150, 200],
                    [10, 20, 50, 100, 150, 200] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": url, // ajax source
                },
                "order": [
                    [column_sorting, dir_sorting]
                ]// set first column as a default sort by asc
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() != "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
            } else if (action.val() == "") {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: 'Please select an action',
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                Metronic.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: 'No record selected',
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });
    }

    return {

        //main function to initiate the module
        init: function (table) {

            handleRecords(table);
        }

    };

}();